<?php

if (!Configure::read('App.installed')) {
    Router::connect('/install/:action', array( 'controller' => 'install' ));
    /*
    header( 'Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0' );
    header( 'Expires: Sat, 26 Jul 1997 05:00:00 GMT' );
    header( 'Location: install/index', true, 301 );
    exit;
    */
    Router::redirect('/**', array( 'controller' => 'install', 'action' => 'index' ), array( 'status' => 307 ));
}




Router::connect('/', array( 'controller' => 'pages', 'action' => 'home' ));
Router::connect('/pages/*', array( 'controller' => 'pages', 'action' => 'view' ));
Router::connect('/members', array( 'controller' => 'users', 'action' => 'dashboard', 'members' => 1 ));
Router::connect('/admin', array( 'controller' => 'users', 'action' => 'dashboard', 'admin' => 1 ));
Router::connect('/login', array( 'controller' => 'users', 'action' => 'login', 'members' => 1 ));
Router::connect('/register', array( 'controller' => 'users', 'action' => 'register', 'members' => 1 ));
Router::connect('/logout', array( 'controller' => 'users', 'action' => 'logout', 'members' => 1 ));
Router::connect('/bundle/:username/:id', array( 'controller' => 'bundles', 'action' => 'view' ), array( 'pass' => array( 'username', 'id' ) ));
Router::connect('/:alias/info', array( 'controller' => 'stats', 'action' => 'view' ), array( 'pass' => array( 'alias' ) ));
App::uses('ShortLink', 'Routing/Route');
Router::connect('/:alias', array( 'controller' => 'links', 'action' => 'view' ), array( 'pass' => array( 'alias' ), 'routeClass' => 'ShortLink' ));



/**
 * Load all plugin routes.  See the CakePlugin documentation on
 * how to customize the loading of plugin routes.
 */
CakePlugin::routes();


Router::mapResources('Api');
Router::parseExtensions();

/**
 * Load the CakePHP default routes. Only remove this if you do not want to use
 * the built-in default routes.
 */
require CAKE . 'Config' . DS . 'routes.php';
